﻿var textHighlightDashboardResults = {
    mainSection: null,
    questionNavigator: null,
    questionNavigatorTable: null,
    language: 'en',
    comments: null,
    commentsTable: null,
    surveyLanguage: 'en',
    wordSearch: ""
}

var selectedVariableId = 0;
var selectedQuestionId = 0;
var questionDescription = "";
var selectedQuestionRow = null;

$(document).ready(function () {
    dashboardLoadResultsConfiguration();
    $("#onDemandUpdate").hide();
    if (textHighlightDashboardResults.mainSection.length > 0) {
        textHighlightDashboardBindQuestion();
    }
});

$('.dashboard-activate-survey').click(function () {
    var parameters = {
        surveyId: a4.getSurveyId()
    };
    var hasActivated = a4.getAction("StartAndDeploySurvey", "Shared", 'Survey');
    a4.callServerMethod(hasActivated, parameters, function (result) {
        if (result['success']) {
            window.location.reload();
        }
    });
});

function dashboardLoadResultsConfiguration() {
    textHighlightDashboardResults.mainSection = $(".text-highlighter-resultsDashboard");
    var configurationSection = $(".v-configurationDashboard", textHighlightDashboardResults.mainSection);
    textHighlightDashboardResults.language = $("#userLanguage", configurationSection).val();
}

function loadLastSelectedQuestionFromConfig(attemptNum) {
    var qnsTableCheckInterval;
    if (textHighlighterConfig) {
        qnsTableCheckInterval = setInterval(function () {
            if ($('tbody>tr', '.h-questionNavigatorDashboard-table').length > 0) {
                clearInterval(qnsTableCheckInterval);
                loadLastSelectedQuestion(textHighlighterConfig, attemptNum);
            }
        }, 1000);
    }
}

function loadLastSelectedQuestion(textHighlighterConfig, attemptNum) {
    var allLoadedQuestions = $('tbody>tr', '.h-questionNavigatorDashboard-table');
    var selectedQuestion = null;

    _.find(allLoadedQuestions, function (item) {
        var currentQn = $(item);
        if (currentQn.data("sourceKey") === textHighlighterConfig.QuestionId) {
            selectedQuestion = currentQn;
            return true;
        }
        return false;
    });

    if (selectedQuestion) {
        loadWidgetsForSelectedQuestion(selectedQuestion, false);
        selectedQuestion.get(0).scrollIntoView();
    }
    else if (attemptNum <= 3) {
        loadLastSelectedQuestionFromConfig(attemptNum + 1);
    }
}

function textHighlightDashboardBindQuestion() {
    textHighlightDashboardResults.questionNavigator = $(".h-questionNavigatorDashboard");
    textHighlightDashboardResults.questionNavigatorTable = $(".h-questionNavigatorDashboard-table", textHighlightDashboardResults.questionNavigator).a4datatable({
        ajaxAction: a4.getSurveyAction("GetQuestionsForTextHighlighter", "TextHighlighter"),
        ajaxParams: { "language": textHighlightDashboardResults.language },

        columns: [
            {
                "Name": "QuestionDefinition",
                "Title": "",
                "Data": function (source, type, val) {
                    var statusIcon = $("<div>").addClass("dashboard-status-icon");
                    if (source['HasDashboard']) {
                        $(statusIcon).append($("<i>")).addClass("fa fa-pie-chart");
                        $(statusIcon).append($("<i>")).find("span").remove();
                    }

                    let jqhtml = $("<div>")
                        .append($("<div>").addClass("question h-goToQuestionDashboard")
                            .attr("title", source.Text)
                            .append($(statusIcon))
                            .append($("<div>").addClass("question-labels-container")
                                .append($("<div>").addClass("name").append(source.Name))
                                .append($("<div>").addClass("text").append(source.Text))));

                    return jqhtml.html();
                }
            }
        ],

        allowRowSelection: false,
        displayColumnSelector: false,

        rowCreated: function (event, d) {
            var currentRow = $(d.row);
            currentRow.data("id", d.data.Id);
            currentRow.data("sourceKey", d.data.SourceKey);
            currentRow.data("variableId", d.data.Variables[0] ? d.data.Variables[0].SourceKey : 0);
            currentRow.data("variableName", d.data.Variables[0] ? d.data.Variables[0].Name : 0);
            currentRow.data("hasDashboard", d.data.HasDashboard);
            currentRow.data("dashboardStatus", d.data.DashboardStatus);
            currentRow.data("textDescriptionParts", d.data.TextDescriptionParts);
            currentRow.data("text", d.data.Text);
            currentRow.data("questionText", d.data.QuestionText);
            currentRow.data("dashboardLastUpdateDateTime", d.data.DashboardLastUpdateDateTime);
            currentRow.data("name", d.data.Name);
            currentRow.data("type", d.data.Type);
            currentRow.data("surveyLanguage", d.data.SurveyLanguage);
        },
        customCallback: function () { loadLastSelectedQuestionFromConfig(1); }
    });

    $(".h-refreshButton", textHighlightDashboardResults.questionNavigatorTable).on("click", function () {
        showInitialInstructions();
    });

    $("input[type=search]", textHighlightDashboardResults.questionNavigatorTable).on("keyup", function (event) {
        var searchText = $("input[type=search]").val();
        // Here key code 13 means, press enter key event
        if (event.which === 13 && searchText.length == 0) {
            setTimeout(addBackgroundColor, 95);
        }
    });

    function addBackgroundColor() {
        $('#DataTables_Table_0 tr td').each(function () {
            $(this).parents("tr").addClass("selected");
        });
    }

    $(textHighlightDashboardResults.questionNavigator).on("click", ".h-goToQuestionDashboard", function (e) {
        var row = $(this).parents("tr");
        $("#wordsSearch").val('');
        questionClickEventHandler(row, true);
    });
}

function questionClickEventHandler(row, updateConfig) {
    $("#onDemandUpdate").hide();
    $(".filterIconDiv").removeClass("hideFilterIcon");
    textHighlightDashboardResults.wordSearch = "";
    $("#wordsDropdownButton").prop('disabled', false);
    $("#chkMorePopular").prop('checked', true);
    $("#chkLessPopular").prop('checked', false);
    if ($(".display-selected-wordtopic").hasClass("visibility-show")) {
        $(".display-selected-wordtopic").removeClass("visibility-show");
        $(".display-selected-wordtopic").addClass("visibility-hide");
    }
    changeRowQuestionDisplay(row, updateConfig);
}

function setCurrentRowSelected(row) {
    var selectedElements = $(".selected", textHighlightDashboardResults.questionNavigatorTable);
    if (selectedElements && selectedElements.length > 0) {
        selectedElements[0].className = selectedElements[0].classList[0];
    }
    row.toggleClass("selected");
}

function changeRowQuestionDisplay(row, updateConfig) {
    selectedQuestionRow = row;
    selectedVariableId = row.data("variableId");
    selectedQuestionId = row.data("sourceKey");
    let hasDashboard = row.data("hasDashboard");
    textHighlightDashboardResults.surveyLanguage = row.data("surveyLanguage");

    if (!hasDashboard) {
        var confirmationResources = modalDialog.createDialogResources(createDashboardResources.CreateDashboardDescription, createDashboardResources.CreateDashboardTitle);
        modalDialog.showConfirmDialog(confirmationResources, function () {
            a4.callServerMethod(a4.getSurveyAction("CheckForLicensesAndResponses", "TextHighlighter"), {
                questionId: selectedQuestionId
            }, function (response) {
                let hasResponses = response['hasResponses'];
                let hasLicenses = response['hasValidLicenses'];

                if (!hasResponses) {
                    setCurrentRowSelected(row);
                    row.toggleClass("selected");
                    a4.showErrorMessage(dashboardErrorMessages.QuestionHasNoResponses);
                    showInitialInstructions();
                }
                else if (!hasLicenses) {
                    setCurrentRowSelected(row);
                    row.toggleClass("selected");
                    a4.showErrorMessage(dashboardErrorMessages.NoLicensesForDashboardCreation);
                    showInitialInstructions();
                }
                else {
                    handleLicensingAndLoadDashboard(row);
                }
            });
        });
    }
    else {
        setCurrentRowSelected(row);
        loadWidgetsForSelectedQuestion(row, updateConfig);
    }
}

function handleLicensingAndLoadDashboard(row) {
    a4.callServerMethod(a4.getSurveyAction("PerformLicensesDeductionAndAssociatedActivities", "TextHighlighter"), {
        questionId: selectedQuestionId
    }, function (response) {
        let status = response['success'];
        row.data("dashboardLastUpdateDateTime", response['modifiedDateTime']);

        if (status) {
            row.data("hasDashboard", true);
            enableDashboardIcon(row);
            setCurrentRowSelected(row);
            loadWidgetsForSelectedQuestion(row, true);
        }
    });
}

function loadWidgetsForSelectedQuestion(row, updateConfig) {
    a4.hideErrorMessage();
    showLoader(createDashboardResources.LoadDashboard);
    selectedQuestionId = row.data("sourceKey");
    selectedQuestionRow = row;
    textHighlightDashboardResults.surveyLanguage = row.data("surveyLanguage");

    a4.callServerMethod(a4.getSurveyAction("GetDataForTextHighlighterDashboardWidgets", "TextHighlighter"), {
        questionId: selectedQuestionId, language: textHighlightDashboardResults.surveyLanguage, wordSearch: textHighlightDashboardResults.wordSearch, updateConfig: updateConfig
    }, function (response) {
        let responsesCount = response['hasResponseCount'];
        let dataObject = response['textHighlighterDataObject'];

        if (responsesCount > 0) {
            $("#onDemandUpdate").show();
            questionDescription = dataObject.TextHighlightQuestionDescriptionList;
            renderTextHighlightsWidget(dataObject.TextHighlightDataItemsList, dataObject.QuestionDescWithColor);
            renderTextHighlightsPerformanceWidget(dataObject.TextHighlightPerformanceList);
            renderTextHighlightsWordPerformanceWidget(dataObject.TextHighlightWords);
            renderTextHighlightsCommentsWidget();
            displayTotalResponsesCount();

            setDashboardInfo(row.data("name"), row.data("dashboardLastUpdateDateTime"));
            hideInitialInstructions();
            checkForUpdatesAvailability();
            hideLoader();
            setCurrentRowSelected(row);

            var textAndQuestionText;
            var textCount = 0;
            $.each(dataObject.TextHighlightQuestionDescriptionList, function (index, value) {
                if (textCount == 0) {
                    textAndQuestionText = value.Text;
        } else {
                    textAndQuestionText = textAndQuestionText + " " + value.Text;
                }
                textCount++;
            });
            selectedQuestionRow.data("text", textAndQuestionText);
            selectedQuestionRow.data("questionText", textAndQuestionText);
        } else {
            row.data("hasDashboard", false);
            disableDashboardIcon(row);
            setCurrentRowSelected(row);
            row.toggleClass("selected");
            hideLoader();
            a4.showErrorMessage(dashboardErrorMessages.QuestionHasNoResponses);
            showInitialInstructions();
        }
    });
}

function checkForUpdatesAvailability() {
    a4.callServerMethod(a4.getSurveyAction("CheckForNewUpdatesOrResponses", "TextHighlighter"), {
        questionId: selectedQuestionId
    }, function (response) {
        let onDemandElement = $("#onDemandButton");
        if (response['hasNewUpdatesOrResponses'] && onDemandElement !== undefined && onDemandElement.length > 0) {
            $("#onDemandButton").removeClass("disabled");
            a4.showSuccessMessage(createDashboardResources.DashboardUpdateAvailable, 3000);
        }
        else if (onDemandElement !== undefined && onDemandElement.length > 0) {
            $("#onDemandButton").addClass("disabled");
        }
    });
}

function runOnDemandUpdate(ev) {
    if (!$(ev).hasClass('disabled')) {
        var confirmationResources = modalDialog.createDialogResources(createDashboardResources.UpdateDashboardDescription, createDashboardResources.UpdateDashboardTitle);
        modalDialog.showConfirmDialog(confirmationResources, function () {
            a4.callServerMethod(a4.getSurveyAction("RunOnDemandUpdate", "TextHighlighter"), {
                questionId: selectedQuestionId
            }, function (response) {
                let hasInValidLicenses = response.hasOwnProperty("hasValidLicenses") && response.hasValidLicenses === false;
                let isSuccess = response.hasOwnProperty("success") && response.success === true;

                if (hasInValidLicenses) {
                    a4.showErrorMessage(dashboardErrorMessages.NoLicensesForDashboardUpdate);
                }
                else if (isSuccess) {
                    selectedQuestionRow.data("dashboardLastUpdateDateTime", response['modifiedDateTime']);
                    loadWidgetsForSelectedQuestion(selectedQuestionRow, true);
                    a4.showSuccessMessage(createDashboardResources.DashboardUpdateSuccess);
                }
            });
        });
    }    
}

function enableDashboardIcon(row) {
    let statusIcon = $('.dashboard-status-icon', $(row));
    $(statusIcon).append($("<i>")).addClass("fa fa-pie-chart");
    $(statusIcon).append($("<i>")).find("span").remove();
}

function disableDashboardIcon(row) {
    let statusIcon = $('.dashboard-status-icon', $(row));
    $(statusIcon).append($("<i>")).removeClass("fa fa-pie-chart");
    $(statusIcon).append($("<i>")).find("span").remove();
}

function setDashboardInfo(questionName, updatedDate) {
    $(".dashboard-name").text(questionName);
    updatedDate = updatedDate === null ? "" : updatedDate;
    $(".dashboard-updated-date .updated-date").text(updatedDate);
}

function hideInitialInstructions() {
    $(".text-highlighter-dashboard-container").show();
    $("#text-highlighter-initialInstructions").hide();
}

function showInitialInstructions() {
    $(".text-highlighter-dashboard-container").hide();
    $("#text-highlighter-initialInstructions").show();
}

function showLoader(loadingText) {
    var loader = $("#loaderIcon");
    if (loadingText && loadingText != "") {
        $(".loading-text-content #loadingStatus", loader).text(loadingText);
    }
    loader.removeClass("hide");
}

function hideLoader() {
    $("#loaderIcon").addClass("hide");
}

// Dashboard Export
$("#btnTextHighlightExport").click(function () {
    var dialogContent = { iconRequired: true, Title: textHighlighterExport.ExportExcelHeader, Message: textHighlighterExport.ExportExcelDescription, ConfirmButton: resources.Confirm };
    modalDialog.showConfirmDialog(dialogContent, function () { exportToExcel(); });
});

function exportToExcel() {
    showLoader(textHighlighterExport.ExportExcelLoadText);

    var params = {
        surveyId: a4.getSurveyId(),
        questionId: selectedQuestionId,
        language: textHighlightDashboardResults.surveyLanguage,
        wordSearch: textHighlightDashboardResults.wordSearch
    };

    var url = a4.getAction("ExportToExcel", "TextHighlighter", "Survey", params);
    window.location.href = url;
    setTimeout(() => {
        hideLoader();
    }, 1000);
}

function displayTotalResponsesCount() {
    a4.callServerMethod(a4.getSurveyAction("GetTotalResponsesCount", "TextHighlighter"), {
        variableId: selectedVariableId, questionId: selectedQuestionId
    }, function (response) {
        $("#responseCount").text(response['TotalResponseCount']);
    });
}